## -*-Tcl-*-
 # ###################################################################
 #  HTML mode: tools for editing HTML documents
 # 
 #  FILE: "htmlMode.tcl"
 #                                    created: 95-04-26 14.49.04 
 #                                last update: 01-12-09 19.40.59 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 3.1.5
 # 
 # version 0.24 (16 July 95) by Scott W. Brim <swb1@cornell.edu>
 # version 1.0 -- 3.1.5 (December 2001) by Johan Linde <alpha_www_tools@go.to>
 #
 # Copyright 1996-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
# This is the main file for HTML mode
#===============================================================================

alpha::mode HTML 3.1.5 htmlMenu \
  {*.html *.htm *.shtml *.HTML *.HTM *.SHTML } {
	cssMenu htmlMenu htmlUtilsMenu electricBraces electricSemicolon electricReturn electricTab
} {
	addMenu htmlMenu
	addMenu htmlUtilsMenu
	hook::register keyboard {Bind '.' <o> {html::electricGreater} HTML} "Canadian - CSA"
	hook::register removekeyboard {unBind '.' <o> {} HTML} "Canadian - CSA"
	hook::register keyboard {Bind '.' <o> {html::electricGreater} HTML} "Canadian - ISO"
	hook::register removekeyboard {unBind '.' <o> {} HTML} "Canadian - ISO"
	# Add more options to the 'New Document' prompt
	proc newHTMLDoc {} {htmlMenu; html::NewDocument}
	proc newHTMLDocWithContent {} {htmlMenu; html::NewwithContent}
	proc newHTMLDocWithFrames {} {htmlMenu; html::NewDoc.withFrames}
	set {newDocTypes(New HTML Doc)} newHTMLDoc
	set {newDocTypes(New HTML Doc With Content)} newHTMLDocWithContent
	set {newDocTypes(New HTML Doc With Frames)} newHTMLDocWithFrames
} uninstall {
	if {[askyesno "This will uninstall both HTML and CSS modes. Continue?"] == "no"} {return}
	set folder [file dirname [procs::find htmlMenu]]
	if {![file exists $folder]} {return}
	catch {file delete [file join $folder *]}
	catch {file delete $folder}
	catch {file delete [file join $HOME Tcl Completions HTMLCompletions.tcl]}
	catch {file delete [file join $HOME Tcl Completions CSSCompletions.tcl]}
	catch {file delete [file join $HOME Help "HTML Help.tcl"]}
	catch {file delete [file join $HOME Help "HTML Help" "bilder" *]}
	catch {file delete [file join $HOME Help "HTML Help" "Style Sheet" *]}
	catch {file delete [file join $HOME Help "HTML Help" "text" *]}
	catch {file delete [file join $HOME Help "HTML Help" *]}
	catch {file delete [file join $HOME Help "HTML Help"]}
} maintainer {
	"Johan Linde" <alpha_www_tools@go.to> <http://go.to/alpha_www_tools>
} help {file "HTML Help"}

# called by Alpha to load HTML in.  
proc htmlMenu {} {}
proc htmlUtilsMenu {} {}

namespace eval html {}
namespace eval css {}

if {$tcl_platform(platform) == "macintosh"} {
    # Register eventhandler for Big Brother events
    eventHandler Bbth Chkd html::BbthChkdHandler 
}

# Used by fillParagraph
set htmlParaCommands {html|head|title|body|h[1-6]|p|div|blockquote|center|address|pre|multicol}
append htmlParaCommands {|br|hr|wbr|basefont|ul|ol|li|dir|menu|dl|dd|dt|form|input}
append htmlParaCommands {|select|option|textarea|caption|table|tr|frameset|frame|noframes}
append htmlParaCommands {|map|area|applet|param|script|noscript|layer|ilayer|nolayer|base|link|meta|isindex}
append htmlParaCommands {|col|colgroup|marquee|object|thead|tbody|tfoot}
append htmlParaCommands {|bdo|ins|del|fieldset|legend|button|optgroup}

# Used by paragraph code
set HTML::startPara {^[ \t]*$|</?(}
append HTML::startPara $htmlParaCommands {)([ \t\r]+[^>]*>|>)}
set HTML::endPara {^[ \t]*$|</?(}
append HTML::endPara $htmlParaCommands {)([ \t\r\n]+[^>]*>|>)}

# Load other HTML mode files.
foreach __tmp {htmlcssInit htmlEntities htmlMenuDefinition html40 cssProperties} {
	if { [catch {eval ${__tmp}.tcl}] } {
		beep
		alertnote "Loading of ${__tmp}.tcl failed"
		return
	}
}

# Clean up tmp files
if {[file exists ${html::TmpFolder}]} {
	if {[file exists [file join ${html::TmpFolder} incl]]} {catch {rm -r [file join ${html::TmpFolder} incl]}}
	if {[file exists [file join ${html::TmpFolder} xincl]]} {catch {rm -r [file join ${html::TmpFolder} xincl]}}
	catch {rm [file join ${html::TmpFolder} *]}
}

# Synchronize indentation with layout, just in case...
set __remtmp ""
foreach __tmp $HTMLmodeVars(indentElements) {
	if {![info exists html::ElemLayout($__tmp)] || [set html::ElemLayout($__tmp)] != "cr2"} {
		lappend __remtmp $__tmp
	}
}
if {[llength $__remtmp]} {
	set HTMLmodeVars(indentElements) [eval lremove [list $HTMLmodeVars(indentElements)] $__remtmp]
	prefs::modifiedModeVar indentElements HTML
}
catch {unset __remtmp __tmp}

#
# Color support
#

proc html::Colorizing {{changing 0}} {
 	global HTMLmodeVars HTMLwords html::formattingStyles css::Property css::Descriptor
 	
 	set HTMLKeyWords {}
	if {[info exists HTMLwords]} {set HTMLKeyWords $HTMLwords}

	if {!$HTMLmodeVars(simpleColoring)} {
		# All HTML elements
		set allHTMLwords {A ABBR ACRONYM ADDRESS APPLET AREA B BASE 
		BASEFONT BDO BGSOUND BIG BLINK BLOCKQUOTE BODY BR BUTTON CAPTION 
		CENTER CITE CODE COL COLGROUP DD DEL DFN DIR DIV DL DT EM EMBED 
		FIELDSET FONT FORM FRAME FRAMESET H1 H2 H3 H4 H5 H6 HEAD HR HTML I 
		IFRAME ILAYER IMG INPUT INS ISINDEX KBD KEYGEN LABEL LAYER LEGEND 
		LI LINK MAP MARQUEE MENU META MULTICOL NOBR NOEMBED NOFRAMES 
		NOLAYER NOSCRIPT OBJECT OL OPTGROUP OPTION P PARAM PRE Q S SAMP 
		SCRIPT SELECT SERVER SMALL SPACER SPAN STRIKE STRONG STYLE SUB SUP TABLE 
		TBODY TD TEXTAREA TFOOT TH THEAD TITLE TR TT U UL VAR WBR}
	

		# All attributes
		set attributeWords {
		ABBR= ABOVE= ACCEPT-CHARSET= ACCEPT= ACCESSKEY= ACTION= ALIGN=
		ALINK= ALT= ARCHIVE= AXIS= BACKGROUND= BEHAVIOR= BELOW= BGCOLOR=
		BGPROPERTIES= BORDER= BORDERCOLOR= BORDERCOLORDARK=
		BORDERCOLORLIGHT= CELLPADDING= CELLSPACING= CHALLENGE= CHAR=
		CHAROFF= CHARSET= CHECKED CITE= CLASS= CLASSID= CLEAR= CLIP= CODE=
		CODEBASE= CODETYPE= COLOR= COLS= COLSPAN= COMPACT CONTENT= CONTROLS
		COORDS= DATA= DATETIME= DECLARE DEFER DIR= DIRECTION= DISABLED
		DYNSRC= ENCTYPE= FACE= FOR= FRAME= FRAMEBORDER= FRAMESPACING=
		GUTTER= HEADERS= HEIGHT= HIDDEN= HREF= HREFLANG= HSPACE=
		HTTP-EQUIV= ID= ISMAP LABEL= LANG= LANGUAGE= LEFT= LEFTMARGIN=
		LINK= LONGDESC= LOOP= LOWSRC= MARGINHEIGHT= MARGINWIDTH= MAXLENGTH=
		MAYSCRIPT MEDIA= METHOD= MULTIPLE NAME= NOHREF NORESIZE NOSHADE
		NOWRAP OBJECT= PAGEX= PAGEY= PALETTE= PLUGINSPAGE= PLUGINSURL=
		POINT-SIZE= PROFILE= PROMPT= READONLY REL= REV= ROWS= ROWSPAN=
		RULES= SCHEME= SCOPE= SCROLLAMOUNT= SCROLLDELAY= SCROLLING=
		SELECTED SHAPE= SIZE= SPAN= SRC= STANDBY= START= STYLE= SUMMARY=
		TABINDEX= TARGET= TEXT= TITLE= TOP= TOPMARGIN= TYPE= UNITS= USEMAP=
		VALIGN= VALUE= VALUETYPE= VISIBILITY= VLINK= VSPACE= WIDTH= WRAP=
		Z-INDEX=
		}
		
		# JavaScript keywords.
		set JavaScriptWords {break case continue default delete do export for import in 
		function if else new return switch this typeof var void while with true false 
		onAbort= onBlur= onChange= onClick= onDblClick= onError= onFocus= 
		onKeyDown= onKeyPress= onKeyUp= onLoad= onMouseDown= onMouseMove= 
		onMouseOut= onMouseOver= onMouseUp= onReset= onSelect= onSubmit= onUnload=}
		# Custom elements
		if {[html::AdditionsExists]} {
			catch {html::ReadCache "Additions coloring cache" 1}
		}
		
		foreach elem $allHTMLwords {
			if {$HTMLmodeVars(ColorImmediately)} {
				lappend allHTMLkeywords $elem
			} else {
				lappend allHTMLkeywords "<${elem}" "/${elem}"
			}
		}

		lappend attributeWords FILE= FORM= INCLPATH= PATH= DEPTH=
		
		if {$HTMLmodeVars(ColorImmediately)} {
			regsub -all = $attributeWords "" attributeWords
			regsub -all = $JavaScriptWords "" JavaScriptWords
		}
		
		# CSS keywords
		set CSSwords [concat [array names css::Property] [array names css::Descriptor] \
		  {@font-face important active after before first first-child first-letter 
		first-line focus hover lang left link right visited}]
	
		if {!$changing} {
			regModeKeywords -i "<" -i ">" -I $HTMLmodeVars(tagColor) \
			  -s $HTMLmodeVars(stringColor)  -b "/*" "*/" -e "//" HTML {}
		}
		if {$HTMLmodeVars(JavaScriptColoring) || $HTMLmodeVars(CSSColoring)} {
			set col $HTMLmodeVars(JavaCommentColor)
		} else {
			set col none
		}
		regModeKeywords -a -c $col HTML
		if {$HTMLmodeVars(JavaScriptColoring)} {
			set col $HTMLmodeVars(JavaScriptColor)
		} else {
			set col none
		}
		regModeKeywords -a -k $col HTML $JavaScriptWords
		if {$HTMLmodeVars(CSSColoring)} {
			set col $HTMLmodeVars(CSSColor)
		} else {
			set col none
		}
		regModeKeywords -a -k $col HTML $CSSwords
		regModeKeywords -a -k $HTMLmodeVars(tagColor) \
		HTML [concat $HTMLKeyWords $allHTMLkeywords]
		regModeKeywords -a -k $HTMLmodeVars(attributeColor) HTML $attributeWords
		set extraWords {"<!--" "-->" "#INCLUDE" "/#INCLUDE"
		"#LASTMODIFIED" "/#LASTMODIFIED" "#DOCINDEX" "/#DOCINDEX"}
		foreach style ${html::formattingStyles} {
			lappend extraWords "#$style" "/#$style"
		}
		regModeKeywords -a -k $HTMLmodeVars(JavaCommentColor) HTML $extraWords
	} else {
		regModeKeywords -b "<" ">" -c $HTMLmodeVars(tagColor) \
		-k $HTMLmodeVars(tagColor) HTML $HTMLKeyWords
	}
}

# Change color when a color variable is changed.
proc html::ChangeColorizing {flag shownAlert} {
	global HTMLmodeVars
	set msg 0
	switch -glob $flag {
		simpleColoring -
		ColorImmediately {
			html::Colorizing
			set msg 1
		}
		JavaScriptColoring -
		attributeColor -
		CSSColoring {
			if {!$HTMLmodeVars(simpleColoring)} {
				html::Colorizing 1
			}
		}
		tagColor {
			if {$HTMLmodeVars(simpleColoring)} {
				regModeKeywords -a -c $HTMLmodeVars(tagColor) HTML
			} else {
				regModeKeywords -a -i "<" -i ">" -I $HTMLmodeVars(tagColor) HTML
				html::Colorizing 1
			}
		}
		JavaScriptColor {
			if {$HTMLmodeVars(JavaScriptColoring) && !$HTMLmodeVars(simpleColoring)} {
				html::Colorizing 1
			}
		}
		JavaCommentColor {
			if {($HTMLmodeVars(JavaScriptColoring) || $HTMLmodeVars(CSSColoring)) && !$HTMLmodeVars(simpleColoring)} {
				regModeKeywords -a -c $HTMLmodeVars(JavaCommentColor) HTML
			}
		}
		CSSColor {
			if {$HTMLmodeVars(CSSColoring) && !$HTMLmodeVars(simpleColoring)} {
				html::Colorizing 1
			}
		}	
		stringColor {
			if {!$HTMLmodeVars(simpleColoring)} {
				regModeKeywords -a -s $HTMLmodeVars(stringColor) HTML
			}
		}
	}
	refresh
	if {$msg && !$shownAlert} {
		alertnote "Coloring will not change until you switch to another window."
		set shownAlert 1
	}
	return $shownAlert
}

trace variable browserSig w html::ToggleBrowser2

# Add browsers to Browsers menu.
menu::insert Browsers items end "(-"
if {![lcontains HTMLmodeVars(browsers) $browserSig]} {
	lappend HTMLmodeVars(browsers) $browserSig
	prefs::modifiedModeVar browsers HTML
}
set html::Browsers {}
set _tmpbrws {}
foreach _brws $HTMLmodeVars(browsers) {
	if {![catch {nameFromAppl $_brws} _name]} {
		set _name [file tail $_name]
		lappend html::Browsers [list $_brws $_name]
		lappend _tmpbrws $_brws
		html::AddBrowserItem $_name $_brws
	} else {
		prefs::modifiedModeVar browsers HTML
	}
}
set HTMLmodeVars(browsers) $_tmpbrws
catch {unset _tmpbrws _brws _name}

html::SetDis
html::BuildWholeMenu htmlMenu
html::BuildWholeMenu htmlUtilsMenu
html::Colorizing
# Check that all home page folders exist.
set tmp_notfind ""
foreach tmp_hp $HTMLmodeVars(homePages) {
	if {![file exists [lindex $tmp_hp 0]] || ![file isdirectory [lindex $tmp_hp 0]]} {
		alertnote "Can't find the folder for the home page [lindex $tmp_hp 1][lindex $tmp_hp 2]"
		set tmp_notfind "[lindex $tmp_hp 1][lindex $tmp_hp 2]"
	}
}
if {$tmp_notfind != ""} {html::HomePages $tmp_notfind}
catch {unset tmp tmp_notfind tmp_hp}

# Define a couple of key bindings.
if {[file exists [file join ${html::PrefsFolder} "HTML entity keys"]]} {
	source [file join ${html::PrefsFolder} "HTML entity keys"]
} else {		
	if {![info exists htmlEntityKeys([list less than])]} {
		set htmlEntityKeys([list less than]) "<U<B<I/,"
		set htmlEntityKeysProc([list less than]) {html::InsertCharacter "less than"}
	}
	if {![info exists htmlEntityKeys([list greater than])]} {
		set htmlEntityKeys([list greater than]) "<U<B<I/."
		set htmlEntityKeysProc([list greater than]) {html::InsertCharacter "greater than"}
	}
	if {![info exists htmlEntityKeys(ampersand)]} {
		set htmlEntityKeys(ampersand) "<U<B<I/7"
		set htmlEntityKeysProc(ampersand) {html::InsertCharacter ampersand}
	}
	if {![info exists htmlEntityKeys([list nonbreak space])]} {
		set htmlEntityKeys([list nonbreak space]) "<U<B<I/ "
		set htmlEntityKeysProc([list nonbreak space]) {html::InsertCharacter "nonbreak space"}
	}
	html::SaveCache "HTML entity keys" "array set htmlEntityKeys [list [array get htmlEntityKeys]]\rarray set htmlEntityKeysProc [list [array get htmlEntityKeysProc]]"
}

bind::fromArray htmlEntityKeys htmlEntityKeysProc 0 HTML
catch {unset htmlEntityKeys htmlEntityKeysProc}

proc html::BindBraces {args} {
	global bind::LeftBrace bind::RightBrace
	eval Bind [keys::toBind ${bind::LeftBrace}] html::LeftBrace HTML
	eval Bind [keys::toBind ${bind::RightBrace}] html::RightBrace HTML
}
proc html::UnBindBraces {args} {
	global bind::LeftBrace bind::RightBrace
	eval unBind [keys::toBind ${bind::LeftBrace}] html::LeftBrace HTML
	eval unBind [keys::toBind ${bind::RightBrace}] html::RightBrace HTML
}
html::BindBraces

# Change mode hook
proc html::ChangeMode {args} {
	css::DisableEnable off
}

# Comment line
Bind 'l' <C>  html::CommentLine HTML

# Register hooks
hook::register saveHook html::UpdateLastMod HTML
hook::register saveasHook html::UpdateLastMod HTML
hook::register quitHook html::QuitHook
hook::register quitHook {html::SaveAllCacheSets URLs}
hook::register quitHook {html::SaveAllCacheSets Targets}
hook::register closeHook html::CloseHook Home
hook::register deactivateHook html::DeactivateHook Home
hook::register activateHook html::ActivateHook HTML
hook::register openHook html::ActivateHook HTML
hook::register keyboard html::BindBraces
hook::register removekeyboard html::UnBindBraces
hook::register changeMode html::ChangeMode HTML

proc HTML::OptionTitlebar {} {
	global html::PopUptag
	return [set html::PopUptag [html::GetAttributes]]
}

proc HTML::OptionTitlebarSelect {item} {
	global html::PopUptag
	if {[lcontains html::PopUptag $item]} {
		html::InsertAttributes $item
	} else {
		error "Not an attribute."
	}
}

proc html::LeftBrace {} {
	global electricBraces
	set old $electricBraces
	if {![html::IsInContainer SCRIPT] && ![html::IsInContainer STYLE] && ![html::IsInCommentContainer C-STYLE-FORMATTING]} {
		set electricBraces 0
	}
	catch {bind::LeftBrace}
	set electricBraces $old
}
proc html::RightBrace {} {
	global electricBraces
	set old $electricBraces
	if {![html::IsInContainer SCRIPT] && ![html::IsInContainer STYLE] && ![html::IsInCommentContainer C-STYLE-FORMATTING]} {
		set electricBraces 0
	}
	catch {bind::RightBrace}
	set electricBraces $old
}

proc HTML::electricSemi {} {
	if {![html::IsInContainer SCRIPT] && ![html::IsInContainer STYLE]} {
		insertText ";"
		return
	}
	set pos [getPos]
	set start [lineStart $pos]
	set text [getText $start $pos]
	
	if {[string first "for" $text] != "-1"} {
		set lefts 0
		set rights 0
		set len [string length $text]
		for {set i 0} {$i < $len} {incr i} {
			case [string index $text $i] in {
				"("	{ incr lefts }
				")"	{ incr rights }
			}
		}
		if {$lefts != $rights} {
			insertText ";"
			return
		}
	}
	
	insertText ";\r" [html::GetIndent $pos]
}

proc HTML::indentLine {} {
	global html::formattingStyles html::indentLineProcs positionAfterIndentation
	foreach style ${html::formattingStyles} {
		if {[html::IsInCommentContainer $style]} {
			if {[set html::indentLineProcs($style)] != ""} {
				eval [set html::indentLineProcs($style)]
			}
			return
		}
	}
	if {[html::IsInContainer STYLE] || [html::IsInContainer SCRIPT]} {::indentLine; return}
	if {[html::IsInContainer PRE]} {return}
	
	set previndent [html::FindIndent]
	set lend [pos::math [nextLineStart [getPos]] - 1]
	if {[pos::compare $lend < [getPos]]} {set lend [maxPos]}
	set thisLine [string trimleft [getText [set lstart [lineStart [getPos]]] $lend ]]
	set thisIndent [html::GetIndent [getPos]]
	if {$thisIndent != $previndent} {
		set pos [getPos]
		set spos [lineStart $pos]
		set pd [pos::diff $pos $spos]
		set sp ""
		regexp {^[ \t]*} [getText $spos [nextLineStart $spos]] sp
		replaceText $lstart $lend "$previndent$thisLine"
		if {![info exists positionAfterIndentation] || $positionAfterIndentation} {
			set sp1 ""
			regexp {^[ \t]*} [getText $spos [nextLineStart $spos]] sp1
			set newpos [pos::math $spos + $pd + [string length $sp1] - [string length $sp]]
			if {[pos::compare $newpos < $spos]} {
				goto $spos
			} else {
				goto $newpos
			}
		} else {
			goto [text::firstNonWsLinePos [getPos]]
		}
    } elseif {[info exists positionAfterIndentation] && !$positionAfterIndentation} {
		goto [text::firstNonWsLinePos [getPos]]
	}
}

proc HTML::correctIndentation {pos {next ""}} {
	global alpha::tclversion HTMLmodeVars html::formattingStyles html::correctIndentProc
	foreach style ${html::formattingStyles} {
		if {[html::IsInCommentContainer $style]} {
			if {[set html::correctIndentProc($style)] != ""} {
				return [eval [set html::correctIndentProc($style)] $pos [list $next]]
			}
			return [posX [text::firstNonWsLinePos $pos]]
		}
	}
	if {[html::IsInContainer STYLE] || [html::IsInContainer SCRIPT]} {
		global mode
		set mode CSS
		if {[alpha::package vsatisfies -loose ${alpha::tclversion} 7.5fc1]} {
			catch {::correctBracesIndentation $pos $next} ret
		} elseif {[alpha::package vsatisfies -loose ${alpha::tclversion} 7.4.2]} {
			catch  {::correctIndentation $pos $next} ret
		} else {
			catch {posX [text::firstNonWsLinePos $pos]} ret
		}
		set mode HTML
		return $ret
	}
	if {[html::IsInContainer PRE]} {
		return [posX [text::firstNonWsLinePos $pos]]
	}
	set pos [pos::math [lineStart [getPos]] - 1]
	if {[pos::compare $pos < [minPos]]} {set pos [minPos]}
	set ind [text::maxSpaceForm [html::FindNextIndent $pos]]
	if {[regexp {^</([^<>]+)>} $next "" tag] && [lcontains HTMLmodeVars(indentElements) [string toupper $tag]]} {
		set ind [text::maxSpaceForm [html::ReduceIndent $ind]]
	}
	return [string length $ind]
}

proc html::electricGreater {} {
	global HTMLmodeVars
	replaceText [getPos] [selEnd] >
	if {!$HTMLmodeVars(electricGreater) || [html::IsInContainer STYLE] || [html::IsInContainer SCRIPT]} {return}
	if {![catch {search -s -f 0 -i 1 -m 0 -r 1 {<[^<>]+>} [pos::math [getPos] - 1]} res] && 
	[pos::compare [lindex $res 1] == [getPos]] && [is::Whitespace [getText [lineStart [lindex $res 0]] [lindex $res 0]]]} {
		  HTML::indentLine
	}
}

Bind '>' {html::electricGreater} HTML

#===============================================================================
#  Mark file  #
#===============================================================================

proc HTML::parseFuncs {} {
	return [html::MarkFile2 0]
}

proc HTML::MarkFile {} {
	html::MarkFile2 1
	message "Marks set."
}

proc html::MarkFile2 {markfile} {
	set pos [minPos]
	set exp "<\[Hh\](\[1-6\])\[^<>\]*>"
	set exp2 "</\[Hh\]\[1-6\]>"
	while {![catch {search -s -f 1 -r 1 -m 0 -i 0 $exp $pos} rs] && 
	![catch {search -s -f 1 -r 1 -m 0 -i 0 $exp2 [lindex $rs 1]} res]} {
		set start [lindex $rs 0]
		set end [lindex $res 1]
		set text [getText $start $end]
		# Remove tabs and returns from text.
		regsub -all "\[\t\r\n\]+" $text " " text
		# remove all tags from text
		set headtext [html::TagStrip $text]
		# Set mark only on one line.
		if {[pos::compare $end > [nextLineStart $start]]} {
			set end [pos::math [nextLineStart $start] - 1]
		}
		
		regexp $exp [getText $start $end] "" indlevel

		if {$indlevel > 0 && $indlevel < 7} {
			set lab [string range "       " 2 $indlevel]
			append lab $lab $indlevel " " $headtext
			# Cut the menu item if it's longer than 30 letters, not to make it too long.
			if {[string length $lab] > 30} {
				set lab "[string range $lab 0 29]"
			}
			if {$markfile} {
				setNamedMark $lab $start $start $end
			} else {
				lappend parse $lab [lineStart $start]
			}
		}
		set pos $end
	}
	if {!$markfile} {return $parse}
}

set htmlModeIsLoaded 1

message "HTML initialization complete."
